/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class LilianaTheNecromancerEffect
extends OneShotEffect {
    private static final FilterCreatureCard filter = new FilterCreatureCard("creature cards from graveyards");

    public LilianaTheNecromancerEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put up to two creature cards from graveyards onto the battlefield under your control";
    }

    private LilianaTheNecromancerEffect(LilianaTheNecromancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaTheNecromancerEffect copy() {
        return new LilianaTheNecromancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInGraveyard target = new TargetCardInGraveyard(0, 2, (FilterCard)filter);
        target.withNotTarget(true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        CardsImpl cardsToMove = new CardsImpl();
        for (UUID targetId : target.getTargets()) {
            Card card = game.getCard(targetId);
            if (card == null) continue;
            cardsToMove.add(card);
        }
        return player.moveCards((Cards)cardsToMove, Zone.BATTLEFIELD, source, game);
    }
}

