/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.LinkedHashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class LilianaVessEffect
extends OneShotEffect {
    LilianaVessEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put all creature cards from all graveyards onto the battlefield under your control";
    }

    private LilianaVessEffect(LilianaVessEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            LinkedHashSet creatureCards = new LinkedHashSet();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                creatureCards.addAll(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
            }
            controller.moveCards(creatureCards, Zone.BATTLEFIELD, source, game, false, false, false, null);
            return true;
        }
        return false;
    }

    public LilianaVessEffect copy() {
        return new LilianaVessEffect(this);
    }
}

