/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Collection;
import java.util.HashMap;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class LilianaWakerOfTheDeadDiscardEffect
extends OneShotEffect {
    LilianaWakerOfTheDeadDiscardEffect() {
        super(Outcome.Discard);
        this.staticText = "Each player discards a card. Each opponent who can't loses 3 life";
    }

    private LilianaWakerOfTheDeadDiscardEffect(LilianaWakerOfTheDeadDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianaWakerOfTheDeadDiscardEffect copy() {
        return new LilianaWakerOfTheDeadDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        HashMap<UUID, CardsImpl> cardsToDiscard = new HashMap<UUID, CardsImpl>();
        if (controller == null) {
            return true;
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            int numberOfCardsToDiscard = Math.min(1, player.getHand().size());
            CardsImpl cards = new CardsImpl();
            TargetDiscard target = new TargetDiscard(numberOfCardsToDiscard, numberOfCardsToDiscard, StaticFilters.FILTER_CARD, playerId);
            player.chooseTarget(this.outcome, (Target)target, source, game);
            cards.addAll((Collection)target.getTargets());
            cardsToDiscard.put(playerId, cards);
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            int amountDiscarded = player.discard((Cards)cardsToDiscard.get(playerId), false, source, game).size();
            if (!controller.hasOpponent(playerId, game) || amountDiscarded != 0) continue;
            player.loseLife(3, game, source, false);
        }
        return true;
    }
}

