/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class LilianasIndignationEffect
extends OneShotEffect {
    LilianasIndignationEffect() {
        super(Outcome.LoseLife);
        this.staticText = "Mill X cards. Target player loses 2 life for each creature card put into your graveyard this way";
    }

    private LilianasIndignationEffect(LilianasIndignationEffect effect) {
        super((OneShotEffect)effect);
    }

    public LilianasIndignationEffect copy() {
        return new LilianasIndignationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (xValue < 1) {
            return true;
        }
        int creatures = controller.millCards(xValue, source, game).getCards(game).stream().filter(Objects::nonNull).filter(card -> game.getState().getZone(card.getId()) == Zone.GRAVEYARD).filter(card1 -> card1.isCreature(game)).mapToInt(x -> 2).sum();
        if (creatures > 0 && (targetPlayer = game.getPlayer(source.getFirstTarget())) != null) {
            game.processAction();
            targetPlayer.loseLife(creatures, game, source, false);
        }
        return true;
    }
}

