/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import java.util.Optional;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LilianasTalentTriggeredAbility
extends TriggeredAbilityImpl {
    LilianasTalentTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DestroyTargetEffect());
    }

    private LilianasTalentTriggeredAbility(LilianasTalentTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public LilianasTalentTriggeredAbility copy() {
        return new LilianasTalentTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!Optional.of(this.getSourcePermanentIfItStillExists(game)).filter(Objects::nonNull).map(Permanent::getAttachedTo).map(event.getTargetId()::equals).orElse(false).booleanValue()) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
        return true;
    }

    public String getRule() {
        return "Whenever a creature deals damage to enchanted planeswalker, destroy that creature.";
    }
}

