/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class LimDulTheNecromancerEffect
extends OneShotEffect {
    LimDulTheNecromancerEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return that card to the battlefield under your control. If it's a creature, it's a Zombie in addition to its other creature types";
    }

    private LimDulTheNecromancerEffect(LimDulTheNecromancerEffect effect) {
        super((OneShotEffect)effect);
    }

    public LimDulTheNecromancerEffect copy() {
        return new LimDulTheNecromancerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
            if (card != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game) && card.isCreature(game)) {
                Permanent creature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
                AddCardSubTypeTargetEffect effect = new AddCardSubTypeTargetEffect(SubType.ZOMBIE, Duration.WhileOnBattlefield);
                effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
                game.addEffect((ContinuousEffect)effect, source);
            }
            return true;
        }
        return false;
    }
}

