/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class LinSivviDefiantHeroEffect
extends OneShotEffect {
    LinSivviDefiantHeroEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for a Rebel permanent card with mana value X or less, put it onto the battlefield, then shuffle";
    }

    private LinSivviDefiantHeroEffect(LinSivviDefiantHeroEffect effect) {
        super((OneShotEffect)effect);
    }

    public LinSivviDefiantHeroEffect copy() {
        return new LinSivviDefiantHeroEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xCost = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        FilterPermanentCard filter = new FilterPermanentCard("Rebel permanent card with mana value " + xCost + " or less");
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xCost + 1));
        filter.add((Predicate)SubType.REBEL.getPredicate());
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)filter);
        if (controller.searchLibrary(target, source, game)) {
            Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
            if (card != null) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }
}

