/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LionSashEffect
extends OneShotEffect {
    LionSashEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target card from a graveyard. If it was a permanent card, put a +1/+1 counter on {this}";
    }

    private LionSashEffect(LionSashEffect effect) {
        super((OneShotEffect)effect);
    }

    public LionSashEffect copy() {
        return new LionSashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (card.isPermanent(game) && permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        return true;
    }
}

