/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class LivingDestinyEffect
extends OneShotEffect {
    LivingDestinyEffect() {
        super(Outcome.GainLife);
        this.staticText = "You gain life equal to the revealed card's mana value";
    }

    private LivingDestinyEffect(LivingDestinyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = (RevealTargetFromHandCost)source.getCosts().get(0);
        if (cost != null) {
            Player player = game.getPlayer(source.getControllerId());
            int CMC = cost.manaValues;
            if (player != null) {
                player.gainLife(CMC, game, source);
            }
        }
        return true;
    }

    public LivingDestinyEffect copy() {
        return new LivingDestinyEffect(this);
    }
}

