/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.l.LobeliaDefenderOfBagEndWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.util.CardUtil;

class LobeliaDefenderOfBagEndPlayFromExileEffect
extends AsThoughEffectImpl {
    LobeliaDefenderOfBagEndPlayFromExileEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "until end of turn, you may play a card exiled with {this} without paying its mana cost";
    }

    private LobeliaDefenderOfBagEndPlayFromExileEffect(LobeliaDefenderOfBagEndPlayFromExileEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public LobeliaDefenderOfBagEndPlayFromExileEffect copy() {
        return new LobeliaDefenderOfBagEndPlayFromExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        LobeliaDefenderOfBagEndWatcher.addPlayable(source, game);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!LobeliaDefenderOfBagEndWatcher.checkPermission(affectedControllerId, source, game)) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (exileZone == null || !exileZone.contains((Object)sourceId)) {
            return false;
        }
        return this.allowCardToPlayWithoutMana(sourceId, source, affectedControllerId, game);
    }
}

