/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayEnergyCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.IndestructibleAbility;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.players.Player;

class LocalizedDestructionEffect
extends OneShotEffect {
    LocalizedDestructionEffect() {
        super(Outcome.AddAbility);
        this.staticText = ", then you may pay one or more {E}. If you do, each creature you control with power equal to the amount of {E} paid this way gains indestructible until end of turn";
    }

    private LocalizedDestructionEffect(LocalizedDestructionEffect effect) {
        super((OneShotEffect)effect);
    }

    public LocalizedDestructionEffect copy() {
        return new LocalizedDestructionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int totalEnergy = controller.getCountersCount(CounterType.ENERGY);
        if (totalEnergy == 0) {
            return false;
        }
        if (!controller.chooseUse(this.getOutcome(), "Pay 1 or more {E}? Each creature you control with power equal to the amount of paid this way gains indestructible until end of turn", source, game)) {
            return true;
        }
        int numberToPay = controller.getAmount(1, totalEnergy, "Pay one or more {E}", source, game);
        PayEnergyCost cost = new PayEnergyCost(numberToPay);
        if (cost.pay(source, game, source, source.getControllerId(), true)) {
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, numberToPay));
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)IndestructibleAbility.getInstance(), Duration.EndOfTurn, filter), source);
        }
        return true;
    }
}

