/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.cards.Card;
import mage.cards.Cards;
import mage.constants.Duration;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class LockeTreasureHunterWatcher
extends Watcher {
    private final Map<MageObjectReference, UUID> morMap = new HashMap<MageObjectReference, UUID>();
    private static final Map<UUID, UUID> playerPermissionMap = new HashMap<UUID, UUID>();
    private final Set<UUID> usedSet = new HashSet<UUID>();

    LockeTreasureHunterWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST || !event.hasApprovingIdentifier(MageIdentifier.LockeTreasureHunterWatcher)) {
            return;
        }
        Optional.ofNullable(event).map(GameEvent::getTargetId).map(arg_0 -> ((Game)game).getSpell(arg_0)).map(spell -> new MageObjectReference((MageObject)spell.getMainCard(), game, -1)).map(mor -> this.morMap.getOrDefault(mor, null)).ifPresent(this.usedSet::add);
    }

    public void reset() {
        super.reset();
        this.morMap.clear();
        playerPermissionMap.clear();
        this.usedSet.clear();
    }

    static void saveCards(Cards cards, Game game, Ability source) {
        ((LockeTreasureHunterWatcher)game.getState().getWatcher(LockeTreasureHunterWatcher.class)).handleSaveCards(cards, game, source);
    }

    private void handleSaveCards(Cards cards, Game game, Ability source) {
        UUID permissionId = UUID.randomUUID();
        playerPermissionMap.put(permissionId, source.getControllerId());
        LockeTreasureHunterCondition condition = new LockeTreasureHunterCondition(permissionId);
        for (Card card : cards.getCards(game)) {
            this.morMap.put(new MageObjectReference((MageObject)card, game), permissionId);
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)false, (UUID)source.getControllerId(), (Condition)condition);
        }
    }

    private boolean checkPermission(UUID permissionId, Ability source, Game game) {
        return !this.usedSet.contains(permissionId) && source.isControlledBy((UUID)playerPermissionMap.getOrDefault(permissionId, null));
    }

    private static class LockeTreasureHunterCondition
    implements Condition {
        private final UUID permissionId;

        LockeTreasureHunterCondition(UUID permissionId) {
            this.permissionId = permissionId;
        }

        public boolean apply(Game game, Ability source) {
            return ((LockeTreasureHunterWatcher)game.getState().getWatcher(LockeTreasureHunterWatcher.class)).checkPermission(this.permissionId, source, game);
        }
    }
}

