/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LongRoadHomeEffect
extends OneShotEffect {
    private static final String effectText = "Exile target creature. At the beginning of the next end step, return that card to the battlefield under its owner's control with a +1/+1 counter on it";

    LongRoadHomeEffect() {
        super(Outcome.Benefit);
        this.staticText = effectText;
    }

    private LongRoadHomeEffect(LongRoadHomeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && permanent.moveToExile(source.getSourceId(), "Long Road Home", source, game)) {
            Card card;
            ExileZone exile = game.getExile().getExileZone(source.getSourceId());
            if (exile != null && !exile.isEmpty() && (card = game.getCard(permanent.getId())) != null) {
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)new ReturnMORToBattlefieldUnderOwnerControlWithCounterEffect(new MageObjectReference((MageObject)card, game), CounterType.P1P1.createInstance(), "a +1/+1 counter")), source);
            }
            return true;
        }
        return false;
    }

    public LongRoadHomeEffect copy() {
        return new LongRoadHomeEffect(this);
    }
}

