/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class LordOfTheVoidEffect
extends OneShotEffect {
    LordOfTheVoidEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile the top seven cards of that player's library, then put a creature card from among them onto the battlefield under your control";
    }

    private LordOfTheVoidEffect(LordOfTheVoidEffect effect) {
        super((OneShotEffect)effect);
    }

    public LordOfTheVoidEffect copy() {
        return new LordOfTheVoidEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        TargetCard target;
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (player == null || controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 7));
        controller.moveCards((Cards)cards, Zone.EXILED, source, game);
        if (!cards.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game).isEmpty() && controller.chooseTarget(this.outcome, (Cards)cards, target = new TargetCard(Zone.EXILED, (FilterCard)StaticFilters.FILTER_CARD_CREATURE), source, game) && (card = cards.get(target.getFirstTarget(), game)) != null) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, false, null);
        }
        return true;
    }
}

