/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.l.LordXanderTheCollectorEffectType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class LordXanderTheCollectorEffect
extends OneShotEffect {
    private final LordXanderTheCollectorEffectType effectType;

    LordXanderTheCollectorEffect(LordXanderTheCollectorEffectType LordXanderTheCollectorEffectType2) {
        super(Outcome.Benefit);
        this.effectType = LordXanderTheCollectorEffectType2;
        switch (this.effectType) {
            case DISCARD: {
                this.staticText = "target opponent discards half the cards in their hand, rounded down";
                break;
            }
            case MILL: {
                this.staticText = "defending player mills half their library, rounded down";
                break;
            }
            case SACRIFICE: {
                this.staticText = "target opponent sacrifices half the nonland permanents they control, rounded down";
            }
        }
    }

    private LordXanderTheCollectorEffect(LordXanderTheCollectorEffect effect) {
        super((OneShotEffect)effect);
        this.effectType = effect.effectType;
    }

    public LordXanderTheCollectorEffect copy() {
        return new LordXanderTheCollectorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        switch (this.effectType) {
            case DISCARD: {
                int count = player.getHand().size();
                if (count < 2) {
                    return false;
                }
                player.discard(count / 2, false, false, source, game);
                return true;
            }
            case MILL: {
                int count = player.getLibrary().size();
                if (count < 2) {
                    return false;
                }
                player.millCards(count / 2, source, game);
                return true;
            }
            case SACRIFICE: {
                int count = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND, player.getId(), game).size();
                if (count < 2) {
                    return false;
                }
                TargetPermanent target = new TargetPermanent(count / 2, (FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_NON_LAND);
                target.withNotTarget(true);
                target.withChooseHint("sacrifice");
                target.setRequired(true);
                player.choose(this.outcome, (Target)target, source, game);
                for (UUID permanentId : target.getTargets()) {
                    Permanent permanent = game.getPermanent(permanentId);
                    if (permanent == null) continue;
                    permanent.sacrifice(source, game);
                }
                return true;
            }
        }
        return false;
    }
}

