/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class LostInTheMazeEffect
extends OneShotEffect {
    LostInTheMazeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put a stun counter on each of those creatures you don't control";
    }

    private LostInTheMazeEffect(LostInTheMazeEffect effect) {
        super((OneShotEffect)effect);
    }

    public LostInTheMazeEffect copy() {
        return new LostInTheMazeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || permanent.isControlledBy(source.getControllerId())) continue;
            permanent.addCounters(CounterType.STUN.createInstance(), source, game);
        }
        return true;
    }
}

