/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.TurnMod;
import mage.players.Player;

class LostIsleCallingEffect
extends OneShotEffect {
    LostIsleCallingEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card for each verse counter on {this}. If it had seven or more verse counters on it, take an extra turn after this one";
    }

    private LostIsleCallingEffect(LostIsleCallingEffect effect) {
        super((OneShotEffect)effect);
    }

    public LostIsleCallingEffect copy() {
        return new LostIsleCallingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        int count = permanent.getCounters(game).getCount(CounterType.VERSE);
        player.drawCards(count, source, game);
        if (count >= 7) {
            game.getState().getTurnMods().add(new TurnMod(player.getId()).withExtraTurn());
        }
        return true;
    }
}

