/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.l.ReturnLoyalCatharEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class LoyalCatharEffect
extends OneShotEffect {
    private static final String effectText = "return it to the battlefield transformed under your control at the beginning of the next end step";

    LoyalCatharEffect() {
        super(Outcome.Benefit);
        this.staticText = effectText;
    }

    private LoyalCatharEffect(LoyalCatharEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        if (Zone.GRAVEYARD == game.getState().getZone(source.getSourceId())) {
            ReturnLoyalCatharEffect effect = new ReturnLoyalCatharEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game.getState().getZoneChangeCounter(source.getSourceId())));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
        }
        return true;
    }

    public LoyalCatharEffect copy() {
        return new LoyalCatharEffect(this);
    }
}

