/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.counters.Counter;
import mage.game.Game;
import mage.players.Player;

enum LumberingMegaslothValue implements DynamicValue
{
    instance;

    private static final Hint hint;

    public static Hint getHint() {
        return hint;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int onPermanents = game.getBattlefield().getActivePermanents(sourceAbility.getControllerId(), game).stream().filter(Objects::nonNull).map(perm -> perm.getCounters(game)).flatMap(counters -> counters.values().stream()).mapToInt(Counter::getCount).sum();
        int onPlayers = game.getState().getPlayersInRange(sourceAbility.getControllerId(), game).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).mapToInt(Player::getCountersTotalCount).sum();
        return onPermanents + onPlayers;
    }

    public LumberingMegaslothValue copy() {
        return this;
    }

    public String toString() {
        return "1";
    }

    public String getMessage() {
        return "counter among players and permanents";
    }

    static {
        hint = new ValueHint("Number of counters", (DynamicValue)instance);
    }
}

