/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class LumengridAugurEffect
extends OneShotEffect {
    LumengridAugurEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Target player draws a card, then discards a card. If that player discards an artifact card this way, untap {this}";
    }

    private LumengridAugurEffect(LumengridAugurEffect effect) {
        super((OneShotEffect)effect);
    }

    public LumengridAugurEffect copy() {
        return new LumengridAugurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanent(source.getSourceId());
        if (player != null) {
            player.drawCards(1, source, game);
            Card discardedCard = player.discardOne(false, false, source, game);
            if (discardedCard != null && discardedCard.isArtifact(game) && sourcePermanent != null) {
                sourcePermanent.untap(game);
            }
            return true;
        }
        return false;
    }
}

