/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.game.Game;
import mage.watchers.common.PlayerGainedLifeWatcher;
import mage.watchers.common.PlayerLostLifeWatcher;

enum LunarConvocationCondition implements Condition
{
    GAINED(false, "you gained life this turn"),
    GAINED_AND_LOST(true, "you gained and lost life this turn");

    private final boolean andLost;
    private final String message;

    private LunarConvocationCondition(boolean andLost, String message) {
        this.andLost = andLost;
        this.message = message;
    }

    public boolean apply(Game game, Ability source) {
        return ((PlayerGainedLifeWatcher)game.getState().getWatcher(PlayerGainedLifeWatcher.class)).getLifeGained(source.getControllerId()) > 0 && (!this.andLost || ((PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class)).getLifeLost(source.getControllerId()) > 0);
    }

    public String toString() {
        return this.message;
    }
}

