/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.StaticFilters;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class LunarchMantle
extends CardImpl {
    static final String rule = "and has \"{1}, Sacrifice a permanent: This creature gains flying until end of turn.\"";

    public LunarchMantle(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        SimpleStaticAbility ability2 = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(2, 2, Duration.WhileOnBattlefield));
        SimpleActivatedAbility abilityToGain = new SimpleActivatedAbility((Effect)new GainAbilitySourceEffect((Ability)FlyingAbility.getInstance(), Duration.EndOfTurn), (Cost)new ManaCostsImpl("{1}"));
        abilityToGain.addCost((Cost)new SacrificeTargetCost(StaticFilters.FILTER_PERMANENT));
        ability2.addEffect((Effect)new GainAbilityAttachedEffect((Ability)abilityToGain, AttachmentType.AURA, Duration.WhileOnBattlefield, rule));
        this.addAbility((Ability)ability2);
    }

    private LunarchMantle(LunarchMantle card) {
        super((CardImpl)card);
    }

    public LunarchMantle copy() {
        return new LunarchMantle(this);
    }
}

