/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.l.LyndeCheerfulTormentorPredicate;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetOpponent;

class LyndeCheerfulTormentorAttachCurseEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent(SubType.CURSE, "Curse attached to you");

    public LyndeCheerfulTormentorAttachCurseEffect() {
        super(Outcome.Benefit);
        this.staticText = "attach a Curse attached to you to one of your opponents. If you do, draw two cards";
    }

    private LyndeCheerfulTormentorAttachCurseEffect(LyndeCheerfulTormentorAttachCurseEffect effect) {
        super((OneShotEffect)effect);
    }

    public LyndeCheerfulTormentorAttachCurseEffect copy() {
        return new LyndeCheerfulTormentorAttachCurseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player opponent;
            TargetOpponent targetOpponent;
            Permanent curse;
            TargetPermanent targetPermanent = new TargetPermanent(filter);
            targetPermanent.withNotTarget(true);
            if (controller.chooseTarget(this.outcome, (Target)targetPermanent, source, game) && (curse = game.getPermanent(targetPermanent.getFirstTarget())) != null && controller.chooseTarget(Outcome.Detriment, (Target)(targetOpponent = new TargetOpponent(true)), source, game) && (opponent = game.getPlayer(targetOpponent.getFirstTarget())) != null) {
                controller.removeAttachment(curse, source, game);
                opponent.addAttachment(curse.getId(), source, game);
                game.informPlayers(curse.getLogName() + " is now attached to " + opponent.getLogName() + ".");
                controller.drawCards(2, source, game);
                return true;
            }
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)LyndeCheerfulTormentorPredicate.instance);
    }
}

