/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class SetSupertypeAllEffect
extends ContinuousEffectImpl {
    private static final FilterNonlandPermanent filter = new FilterNonlandPermanent();

    public SetSupertypeAllEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.staticText = "All nonland permanents are legendary";
        this.dependendToTypes.add(DependencyType.BecomeNonbasicLand);
    }

    private SetSupertypeAllEffect(SetSupertypeAllEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public SetSupertypeAllEffect copy() {
        return new SetSupertypeAllEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game)) {
            permanent.addSuperType(game, SuperType.LEGENDARY);
        }
        return true;
    }
}

