/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.l;

import java.util.UUID;
import mage.MageItem;
import mage.filter.predicate.ObjectSourcePlayer;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.StackObject;
import mage.target.Target;

class SharesTypePredicate
implements ObjectSourcePlayerPredicate<MageItem> {
    SharesTypePredicate() {
    }

    public boolean apply(ObjectSourcePlayer<MageItem> input, Game game) {
        StackObject source = game.getStack().getStackObject(input.getSourceId());
        if (source != null) {
            if (source.getStackAbility().getTargets().isEmpty() || ((Target)source.getStackAbility().getTargets().get(0)).getTargets().isEmpty()) {
                return true;
            }
            Permanent firstPermanent = game.getPermanent((UUID)((Target)source.getStackAbility().getTargets().get(0)).getTargets().get(0));
            Permanent secondPermanent = game.getPermanent(((MageItem)input.getObject()).getId());
            if (firstPermanent != null && secondPermanent != null) {
                if (firstPermanent.isCreature(game) && secondPermanent.isCreature(game)) {
                    return true;
                }
                if (firstPermanent.isArtifact(game) && secondPermanent.isArtifact(game)) {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    public String toString() {
        return "Target permanent that shares the type of artifact or creature";
    }
}

