/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class MaarikaBrutalGladiatorWatcher
extends Watcher {
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    MaarikaBrutalGladiatorWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT && ((DamagedEvent)event).getExcess() >= 1) {
            this.morSet.add(new MageObjectReference(event.getTargetId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.morSet.clear();
    }

    static boolean checkPermanent(Permanent input, Game game) {
        return ((MaarikaBrutalGladiatorWatcher)game.getState().getWatcher(MaarikaBrutalGladiatorWatcher.class)).morSet.stream().anyMatch(mor -> mor.refersTo((MageObject)input, game));
    }
}

