/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.ManaChoice;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MadScienceFairProjectEffect
extends OneShotEffect {
    MadScienceFairProjectEffect() {
        super(Outcome.Benefit);
        this.staticText = "Roll a six-sided die. On a 3 or lower, target player adds {C}. Otherwise, that player adds one mana of any color they choose";
    }

    private MadScienceFairProjectEffect(MadScienceFairProjectEffect effect) {
        super((OneShotEffect)effect);
    }

    public MadScienceFairProjectEffect copy() {
        return new MadScienceFairProjectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        int amount = controller.rollDice(this.outcome, source, game, 6);
        Mana mana = amount <= 3 ? Mana.ColorlessMana((int)1) : ManaChoice.chooseAnyColor((Player)player, (Game)game, (int)1);
        player.getManaPool().addMana(mana, game, source);
        return true;
    }
}

