/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class MaddeningCacophonyEffect
extends OneShotEffect {
    MaddeningCacophonyEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent mills eight cards. If this spell was kicked, instead each opponent mills half their library, rounded up";
    }

    private MaddeningCacophonyEffect(MaddeningCacophonyEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaddeningCacophonyEffect copy() {
        return new MaddeningCacophonyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean kicked = KickedCondition.ONCE.apply(game, source);
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            int toMill = 8;
            if (kicked) {
                toMill = Math.floorDiv(player.getLibrary().size(), 2) + player.getLibrary().size() % 2;
            }
            player.millCards(toMill, source, game);
        }
        return true;
    }
}

