/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class MaestrosAscendancyWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<UUID>> playerMap = new HashMap<MageObjectReference, Set<UUID>>();
    private final Map<MageObjectReference, Set<MageObjectReference>> spellMap = new HashMap<MageObjectReference, Set<MageObjectReference>>();

    MaestrosAscendancyWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST && event.hasApprovingIdentifier(MageIdentifier.MaestrosAscendencyAlternateCast) && event.getApprovingObject() != null) {
            this.playerMap.computeIfAbsent(event.getApprovingObject().getApprovingMageObjectReference(), x -> new HashSet()).add(event.getPlayerId());
            this.spellMap.computeIfAbsent(event.getApprovingObject().getApprovingMageObjectReference(), x -> new HashSet()).add(new MageObjectReference(event.getTargetId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.playerMap.clear();
        this.spellMap.clear();
    }

    static boolean checkPlayer(Ability source, Game game) {
        return ((MaestrosAscendancyWatcher)game.getState().getWatcher(MaestrosAscendancyWatcher.class)).playerMap.getOrDefault(new MageObjectReference((MageObject)source.getSourcePermanentIfItStillExists(game), game), Collections.emptySet()).contains(source.getControllerId());
    }

    static boolean checkSpell(Spell spell, Ability source, Game game) {
        return ((MaestrosAscendancyWatcher)game.getState().getWatcher(MaestrosAscendancyWatcher.class)).spellMap.getOrDefault(new MageObjectReference((MageObject)source.getSourcePermanentOrLKI(game), game), Collections.emptySet()).contains(new MageObjectReference((MageObject)spell, game));
    }
}

