/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;
import mage.util.ManaUtil;

class MagneticMountainEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter2 = new FilterControlledCreaturePermanent("tapped blue creature");

    MagneticMountainEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player may choose any number of tapped blue creatures they control and pay {4} for each creature chosen this way. If the player does, untap those creatures.";
    }

    private MagneticMountainEffect(MagneticMountainEffect effect) {
        super((OneShotEffect)effect);
    }

    public MagneticMountainEffect copy() {
        return new MagneticMountainEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        int countBattlefield = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter2, game.getActivePlayerId(), game).size();
        while (player.canRespond() && countBattlefield > 0 && player.chooseUse(Outcome.Benefit, "Pay {4} and untap a tapped blue creature under your control?", source, game)) {
            TargetControlledPermanent tappedCreatureTarget = new TargetControlledPermanent((FilterControlledPermanent)filter2);
            tappedCreatureTarget.withNotTarget(true);
            if (!player.choose(Outcome.Untap, (Target)tappedCreatureTarget, source, game)) break;
            ManaCost cost = ManaUtil.createManaCost((int)4, (boolean)false);
            Permanent tappedCreature = game.getPermanent(tappedCreatureTarget.getFirstTarget());
            if (tappedCreature == null || !cost.pay(source, game, source, player.getId(), false)) break;
            tappedCreature.untap(game);
            countBattlefield = game.getBattlefield().getAllActivePermanents((FilterPermanent)filter2, game.getActivePlayerId(), game).size();
        }
        return true;
    }

    static {
        filter2.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
        filter2.add((Predicate)TappedPredicate.TAPPED);
    }
}

