/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MagusLuceaKaneTriggeredAbility
extends DelayedTriggeredAbility {
    MagusLuceaKaneTriggeredAbility() {
        super((Effect)new CopyStackObjectEffect("that spell or ability"), Duration.EndOfTurn, true, false);
        this.setTriggerPhrase("When you next cast a spell with {X} in its mana cost or activate an ability with {X} in its activation cost this turn, ");
    }

    private MagusLuceaKaneTriggeredAbility(MagusLuceaKaneTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public MagusLuceaKaneTriggeredAbility copy() {
        return new MagusLuceaKaneTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        StackAbility stackAbility;
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        if (event.getType() == GameEvent.EventType.ACTIVATED_ABILITY && (stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId())) != null && stackAbility.getManaCostsToPay().containsX()) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.getSpellAbility().getManaCostsToPay().containsX()) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
            return true;
        }
        return false;
    }
}

