/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class MairsilThePretenderGainAbilitiesEffect
extends ContinuousEffectImpl {
    private static final FilterCard filter = new FilterCard();

    public MairsilThePretenderGainAbilitiesEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of all cards you own in exile with cage counters on them. You may activate each of those abilities only once each turn";
    }

    private MairsilThePretenderGainAbilitiesEffect(MairsilThePretenderGainAbilitiesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm == null) {
            return false;
        }
        for (Card card : game.getExile().getCardsOwned(filter, perm.getControllerId(), source, game)) {
            for (Ability ability : card.getAbilities(game)) {
                if (!ability.isActivatedAbility()) continue;
                ActivatedAbility copyAbility = (ActivatedAbility)ability.copy();
                copyAbility.setMaxActivationsPerTurn(1);
                perm.addAbility((Ability)copyAbility, source.getSourceId(), game, true);
            }
        }
        return true;
    }

    public MairsilThePretenderGainAbilitiesEffect copy() {
        return new MairsilThePretenderGainAbilitiesEffect(this);
    }

    static {
        filter.add((Predicate)CounterType.CAGE.getPredicate());
    }
}

