/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.m.MakeshiftMannequinGainAbilityEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.util.CardUtil;

class MakeshiftMannequinEffect
extends OneShotEffect {
    MakeshiftMannequinEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return target creature card from your graveyard to the battlefield with a mannequin counter on it. For as long as that creature has a mannequin counter on it, it has \"When this creature becomes the target of a spell or ability, sacrifice it.\"";
    }

    private MakeshiftMannequinEffect(MakeshiftMannequinEffect effect) {
        super((OneShotEffect)effect);
    }

    public MakeshiftMannequinEffect copy() {
        return new MakeshiftMannequinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            UUID cardId = this.getTargetPointer().getFirst(game, source);
            Card card = controller.getGraveyard().get(cardId, game);
            if (card != null) {
                Permanent permanent;
                Counters counters = new Counters(new Counter[0]);
                counters.addCounter(CounterType.MANNEQUIN.createInstance());
                game.setEnterWithCounters(cardId, counters);
                if (controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
                    MakeshiftMannequinGainAbilityEffect gainedEffect = new MakeshiftMannequinGainAbilityEffect();
                    SimpleStaticAbility gainAbility = new SimpleStaticAbility((Effect)gainedEffect);
                    gainAbility.setSourceId(cardId);
                    gainAbility.getTargets().add((Target)source.getTargets().get(0));
                    game.addEffect((ContinuousEffect)gainedEffect, (Ability)gainAbility);
                    return true;
                }
            }
        }
        return false;
    }
}

