/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MammothHarnessTriggeredAbility
extends TriggeredAbilityImpl {
    public MammothHarnessTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn), false);
    }

    private MammothHarnessTriggeredAbility(MammothHarnessTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent aura = this.getSourcePermanentIfItStillExists(game);
        if (aura == null) {
            return false;
        }
        Permanent otherCreature = null;
        if (event.getSourceId().equals(aura.getAttachedTo())) {
            otherCreature = game.getPermanent(event.getTargetId());
        } else if (event.getTargetId().equals(aura.getAttachedTo())) {
            otherCreature = game.getPermanent(event.getSourceId());
        }
        if (otherCreature == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(otherCreature, game));
        return true;
    }

    public String getRule() {
        return " Whenever enchanted creature blocks or becomes blocked by a creature, the other creature gains first strike until end of turn.";
    }

    public MammothHarnessTriggeredAbility copy() {
        return new MammothHarnessTriggeredAbility(this);
    }
}

