/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.Mana;
import mage.abilities.ActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveCountersSourceCost;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.CountersSourceCount;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.constants.PhaseStep;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class ManaCacheManaAbility
extends ActivatedManaAbilityImpl {
    public ManaCacheManaAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new BasicManaEffect(Mana.ColorlessMana((int)1), (DynamicValue)new CountersSourceCount(CounterType.CHARGE)), (Cost)new RemoveCountersSourceCost(CounterType.CHARGE.createInstance(1)));
        this.netMana.add(new Mana(0, 0, 0, 0, 0, 0, 0, 1));
        this.setMayActivate(TargetController.ANY);
    }

    private ManaCacheManaAbility(ManaCacheManaAbility ability) {
        super((ActivatedManaAbilityImpl)ability);
    }

    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Player player = game.getPlayer(playerId);
        if (player == null || !playerId.equals(game.getActivePlayerId()) || !game.getTurnStepType().isBefore(PhaseStep.END_TURN)) {
            return ActivatedAbility.ActivationStatus.getFalse();
        }
        return super.canActivate(playerId, game);
    }

    public ManaCacheManaAbility copy() {
        return new ManaCacheManaAbility(this);
    }

    public String getRule() {
        return super.getRule() + " Any player may activate this ability but only during their turn before the end step.";
    }
}

