/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ManaClashEffect
extends OneShotEffect {
    ManaClashEffect() {
        super(Outcome.Detriment);
        this.staticText = "You and target opponent each flip a coin. {this} deals 1 damage to each player whose coin comes up tails. Repeat this process until both players' coins come up heads on the same flip";
    }

    private ManaClashEffect(ManaClashEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManaClashEffect copy() {
        return new ManaClashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetOpponent != null) {
            boolean bothHeads = false;
            while (!bothHeads) {
                if (!targetOpponent.canRespond() || !controller.canRespond()) {
                    return false;
                }
                boolean controllerFlip = controller.flipCoin(source, game, false);
                boolean opponentFlip = targetOpponent.flipCoin(source, game, false);
                if (controllerFlip && opponentFlip) {
                    bothHeads = true;
                }
                if (!controllerFlip) {
                    controller.damage(1, source.getSourceId(), source, game);
                }
                if (opponentFlip) continue;
                targetOpponent.damage(1, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

