/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;

class MangaraTheDiplomatTriggeredAbility
extends TriggeredAbilityImpl {
    MangaraTheDiplomatTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1));
    }

    private MangaraTheDiplomatTriggeredAbility(MangaraTheDiplomatTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean checkTrigger(GameEvent event, Game game) {
        Player player = game.getPlayer(this.getControllerId());
        if (player == null) return false;
        if (!player.hasOpponent(game.getActivePlayerId(), game)) return false;
        if (game.getCombat().getAttackers().stream().map(uuid -> game.getCombat().getDefendingPlayerId(uuid, game)).filter(this.getControllerId()::equals).count() < 2L) return false;
        return true;
    }

    public MangaraTheDiplomatTriggeredAbility copy() {
        return new MangaraTheDiplomatTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever an opponent attacks with creatures, if two or more of those creatures are attacking you and/or planeswalkers you control, draw a card.";
    }
}

