/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class MangarasEquityColorChoiceEffect
extends OneShotEffect {
    MangarasEquityColorChoiceEffect() {
        super(Outcome.Neutral);
        this.staticText = "choose black or red";
    }

    private MangarasEquityColorChoiceEffect(MangarasEquityColorChoiceEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor(true, "Choose a color.", (MageObject)permanent);
        choice.removeColorFromChoices("White");
        choice.removeColorFromChoices("Blue");
        choice.removeColorFromChoices("Green");
        if (controller == null || !controller.choose(this.outcome, (Choice)choice, game)) {
            return false;
        }
        game.informPlayers(permanent.getLogName() + ": " + controller.getLogName() + " has chosen " + choice.getChoice());
        game.getState().setValue(permanent.getId() + "_color", (Object)choice.getColor());
        permanent.addInfo("chosen color", CardUtil.addToolTipMarkTags((String)("Chosen color: " + choice.getChoice())), game);
        return true;
    }

    public MangarasEquityColorChoiceEffect copy() {
        return new MangarasEquityColorChoiceEffect(this);
    }
}

