/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.SavedDamageValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MangarasEquityTriggeredAbility
extends TriggeredAbilityImpl {
    MangarasEquityTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)SavedDamageValue.MUCH));
    }

    private MangarasEquityTriggeredAbility(MangarasEquityTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER || event.getType() == GameEvent.EventType.DAMAGED_PERMANENT;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent damagedPermanent;
        Permanent mangarasEquity = game.getPermanentOrLKIBattlefield(this.getSourceId());
        if (mangarasEquity == null) {
            return false;
        }
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER ? !event.getTargetId().equals(this.getControllerId()) : (damagedPermanent = game.getPermanent(event.getTargetId())) == null || !damagedPermanent.isControlledBy(this.getControllerId()) || !damagedPermanent.isCreature() || !damagedPermanent.getColor().shares(ObjectColor.WHITE)) {
            return false;
        }
        Permanent damageSource = game.getPermanent(event.getSourceId());
        ObjectColor chosenColor = (ObjectColor)game.getState().getValue(mangarasEquity.getId() + "_color");
        if (damageSource != null && chosenColor != null && damageSource.isCreature() && damageSource.getColor().shares(chosenColor)) {
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof DamageTargetEffect)) continue;
                effect.setTargetPointer((TargetPointer)new FixedTarget(damageSource.getId(), game));
            }
            this.getEffects().setValue("damage", (Object)event.getAmount());
            return true;
        }
        return false;
    }

    public MangarasEquityTriggeredAbility copy() {
        return new MangarasEquityTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature of the chosen color deals damage to you or a white creature you control, {this} deals that much damage to that creature.";
    }
}

