/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class MangarasTomeReplacementEffect
extends ReplacementEffectImpl {
    MangarasTomeReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.DrawCard);
        this.staticText = "The next time you would draw a card this turn, instead put the top card of the exiled pile into its owner's hand";
    }

    private MangarasTomeReplacementEffect(MangarasTomeReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public MangarasTomeReplacementEffect copy() {
        return new MangarasTomeReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = game.getExile().getExileZone(CardUtil.getCardExileZoneId((Game)game, (Ability)source)).getRandom(game)) != null) {
            controller.moveCards(card, Zone.HAND, source, game);
        }
        this.used = true;
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return !this.used && source.isControlledBy(event.getPlayerId());
    }
}

