/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class MangarasTomeSearchEffect
extends OneShotEffect {
    MangarasTomeSearchEffect() {
        super(Outcome.Neutral);
        this.staticText = "search your library for five cards, exile them in a face-down pile, and shuffle that pile. Then shuffle your library";
    }

    private MangarasTomeSearchEffect(MangarasTomeSearchEffect effect) {
        super((OneShotEffect)effect);
    }

    public MangarasTomeSearchEffect copy() {
        return new MangarasTomeSearchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && permanent != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(5, new FilterCard());
            if (controller.searchLibrary(target, source, game)) {
                for (UUID targetId : target.getTargets()) {
                    Card card = controller.getLibrary().getCard(targetId, game);
                    if (card == null) continue;
                    controller.moveCardsToExile(card, source, game, false, CardUtil.getCardExileZoneId((Game)game, (Ability)source), permanent.getName());
                    card.setFaceDown(true, game);
                }
            }
            return true;
        }
        return false;
    }
}

