/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;

class ManorGuardianEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterNonlandCard();

    ManorGuardianEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player seeks a nonland card with mana value 2 or less";
    }

    private ManorGuardianEffect(ManorGuardianEffect effect) {
        super((OneShotEffect)effect);
    }

    public ManorGuardianEffect copy() {
        return new ManorGuardianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            player.seekCard(filter, source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

