/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.m.MarchOfRecklessJoyCondition;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class MarchOfRecklessJoyEffect
extends OneShotEffect {
    MarchOfRecklessJoyEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top X cards of your library. You may play up to two of those cards until the end of your next turn.";
    }

    private MarchOfRecklessJoyEffect(MarchOfRecklessJoyEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarchOfRecklessJoyEffect copy() {
        return new MarchOfRecklessJoyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (player == null || xValue < 1 || player.getLibrary().size() < 1) {
            return false;
        }
        Set cards = player.getLibrary().getTopCards(game, xValue);
        player.moveCardsToExile(cards, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        for (Card card : cards) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)false, null, (Condition)MarchOfRecklessJoyCondition.instance);
        }
        return true;
    }
}

