/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class MarchOfTheDroidsEffect
extends OneShotEffect {
    MarchOfTheDroidsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Remove all repair counters from all cards in your graveyard. Return each card with a repair counter removed this way from graveyard to the battlefield";
    }

    private MarchOfTheDroidsEffect(MarchOfTheDroidsEffect effect) {
        super((OneShotEffect)effect);
    }

    public MarchOfTheDroidsEffect copy() {
        return new MarchOfTheDroidsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CardsImpl cardsToReturn = new CardsImpl();
            for (Card card : controller.getGraveyard().getCards(game)) {
                int number;
                if (!card.isOwnedBy(controller.getId()) || card.getCounters(game).getCount(CounterType.REPAIR) <= 0 || (number = card.getCounters(game).getCount(CounterType.REPAIR)) <= 0) continue;
                cardsToReturn.add(card);
                card.removeCounters(CounterType.REPAIR.createInstance(number), source, game);
            }
            if (!cardsToReturn.isEmpty()) {
                controller.moveCards((Cards)cardsToReturn, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

