/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MarchesaTheBlackRoseEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MarchesaTheBlackRoseTriggeredAbility
extends TriggeredAbilityImpl {
    public MarchesaTheBlackRoseTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MarchesaTheBlackRoseEffect());
        this.setTriggerPhrase("Whenever a creature you control with a +1/+1 counter on it dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MarchesaTheBlackRoseTriggeredAbility(MarchesaTheBlackRoseTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MarchesaTheBlackRoseTriggeredAbility copy() {
        return new MarchesaTheBlackRoseTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && (permanent = ((ZoneChangeEvent)event).getTarget()) != null && permanent.isControlledBy(this.getControllerId()) && permanent.isCreature(game) && permanent.getCounters(game).getCount(CounterType.P1P1) > 0) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), permanent.getZoneChangeCounter(game) + 1));
            }
            return true;
        }
        return false;
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

