/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.BlocksIfAbleTargetEffect;
import mage.abilities.effects.common.combat.CantBlockAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MarkForDeathEffect
extends OneShotEffect {
    MarkForDeathEffect() {
        super(Outcome.Damage);
        this.staticText = "Target creature an opponent controls blocks this turn if able. Untap that creature. Other creatures that player controls can't block this turn";
    }

    private MarkForDeathEffect(MarkForDeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new ControllerIdPredicate(target.getControllerId()));
        filter.add(Predicates.not((Predicate)new CardIdPredicate(target.getId())));
        BlocksIfAbleTargetEffect effect = new BlocksIfAbleTargetEffect(Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(target.getId()));
        game.addEffect((ContinuousEffect)effect, source);
        target.untap(game);
        CantBlockAllEffect effect2 = new CantBlockAllEffect(filter, Duration.EndOfTurn);
        game.addEffect((ContinuousEffect)effect2, source);
        return true;
    }

    public MarkForDeathEffect copy() {
        return new MarkForDeathEffect(this);
    }
}

