/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.MageObject;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.m.MartyrsBondEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class MartyrsBondTriggeredAbility
extends TriggeredAbilityImpl {
    public MartyrsBondTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new MartyrsBondEffect());
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private MartyrsBondTriggeredAbility(MartyrsBondTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public MartyrsBondTriggeredAbility copy() {
        return new MartyrsBondTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && (permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD)) != null && permanent.isControlledBy(this.getControllerId()) && !permanent.isLand(game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} or another nonland permanent you control is put into a graveyard from the battlefield, each opponent sacrifices a permanent that shares a card type with it.";
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }
}

