/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Controllable;
import mage.game.Game;
import mage.players.Player;

class MartyrsCryEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent();

    MartyrsCryEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile all white creatures. For each creature exiled this way, its controller draws a card.";
    }

    private MartyrsCryEffect(MartyrsCryEffect effect) {
        super((OneShotEffect)effect);
    }

    public MartyrsCryEffect copy() {
        return new MartyrsCryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        List permanents = game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game);
        Map playerMap = permanents.stream().filter(Objects::nonNull).map(Controllable::getControllerId).collect(Collectors.toMap(Function.identity(), uuid -> 1, Integer::sum));
        controller.moveCards((Cards)new CardsImpl(permanents), Zone.EXILED, source, game);
        game.processAction();
        for (Map.Entry entry : playerMap.entrySet()) {
            Player player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            player.drawCards(entry.getValue().intValue(), source, game);
        }
        return true;
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

