/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.common.TargetCardInLibrary;

class MaskOfTheMimicEffect
extends OneShotEffect {
    MaskOfTheMimicEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library for a card with the same name as target nontoken creature, put that card onto the battlefield, then shuffle.";
    }

    private MaskOfTheMimicEffect(MaskOfTheMimicEffect effect) {
        super((OneShotEffect)effect);
    }

    public MaskOfTheMimicEffect copy() {
        return new MaskOfTheMimicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null) {
            return false;
        }
        FilterCard filter = new FilterCard("a card named " + creature.getName());
        filter.add((Predicate)new NamePredicate(creature.getName()));
        return new SearchLibraryPutInPlayEffect(new TargetCardInLibrary(filter)).apply(game, source);
    }
}

