/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.m;

import java.util.HashSet;
import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class MassPolymorphEffect
extends OneShotEffect {
    MassPolymorphEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile all creatures you control, then reveal cards from the top of your library until you reveal that many creature cards. Put all creature cards revealed this way onto the battlefield, then shuffle the rest of the revealed cards into your library";
    }

    private MassPolymorphEffect(MassPolymorphEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet creaturesToExile = new HashSet(game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game));
            int count = creaturesToExile.size();
            controller.moveCards(creaturesToExile, Zone.EXILED, source, game);
            CardsImpl revealed = new CardsImpl();
            LinkedHashSet<Card> creatureCards = new LinkedHashSet<Card>();
            for (Card card : controller.getLibrary().getCards(game)) {
                revealed.add(card);
                if (!card.isCreature(game)) continue;
                creatureCards.add(card);
                if (creatureCards.size() != count) continue;
                break;
            }
            controller.revealCards(source, (Cards)revealed, game);
            controller.moveCards(creatureCards, Zone.BATTLEFIELD, source, game, false, false, true, null);
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public MassPolymorphEffect copy() {
        return new MassPolymorphEffect(this);
    }
}

